/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.OrbitTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.setup.registry.DataSerializers;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityOrbitProjectile
extends EntityProjectileSpell {
    public int ticksLeft;
    public static final EntityDataAccessor<Vec3> LAST_POS = SynchedEntityData.defineId(EntityOrbitProjectile.class, (EntityDataSerializer)((EntityDataSerializer)DataSerializers.VEC.get()));
    public static final EntityDataAccessor<Integer> OFFSET = SynchedEntityData.defineId(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> ACCELERATES = SynchedEntityData.defineId(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.defineId(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> TOTAL = SynchedEntityData.defineId(EntityOrbitProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int extendTimes;
    public boolean tracksGround;

    public EntityOrbitProjectile(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), worldIn, x, y, z);
    }

    public EntityOrbitProjectile(Level worldIn, LivingEntity shooter) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), worldIn, shooter);
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world, resolver);
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver, Entity tracking) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world, resolver);
        this.setOwner(tracking);
        this.entityData.set(LAST_POS, (Object)tracking.position());
    }

    public EntityOrbitProjectile(Level world, SpellResolver resolver, Vec3 hitPos) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.ORBIT_SPELL.get()), world, resolver);
        this.setOwner(null);
        this.tracksGround = true;
        this.entityData.set(LAST_POS, (Object)hitPos);
    }

    public EntityOrbitProjectile(EntityType<EntityOrbitProjectile> entityWardProjectileEntityType, Level world) {
        super((EntityType<? extends EntityProjectileSpell>)entityWardProjectileEntityType, world);
    }

    public void setOffset(int offset) {
        this.entityData.set(OFFSET, (Object)offset);
    }

    public int getOffset() {
        int val = 15;
        return (Integer)this.entityData.get(OFFSET) * val;
    }

    public void setTotal(int total) {
        this.entityData.set(TOTAL, (Object)total);
    }

    public int getTotal() {
        return (Integer)this.entityData.get(TOTAL) > 0 ? (Integer)this.entityData.get(TOTAL) : 1;
    }

    public void setAccelerates(int accelerates) {
        this.entityData.set(ACCELERATES, (Object)accelerates);
    }

    public int getAccelerates() {
        return (Integer)this.entityData.get(ACCELERATES);
    }

    public void setAoe(float aoe) {
        this.entityData.set(AOE, (Object)Float.valueOf(aoe));
    }

    public float getAoe() {
        return ((Float)this.entityData.get(AOE)).floatValue();
    }

    public double getRotateSpeed() {
        return 10.0 - (double)this.getAccelerates();
    }

    public double getRadiusMultiplier() {
        return 1.5 + 0.5 * (double)this.getAoe();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getOwner() == null) {
            this.tracksGround = true;
        }
    }

    @Override
    public Vec3 getNextHitPosition() {
        return this.getAngledPosition(this.tickCount + 3);
    }

    @Override
    public void tickNextPosition() {
        this.setPos(this.getAngledPosition(this.tickCount));
    }

    public Vec3 getAngledPosition(int nextTick) {
        double rotateSpeed = this.getRotateSpeed();
        double radiusMultiplier = this.getRadiusMultiplier();
        Entity owner = this.getOwner();
        if (owner == null || owner.isRemoved() || this.tracksGround) {
            Vec3 lastVec = (Vec3)this.entityData.get(LAST_POS);
            return new Vec3(lastVec.x() - radiusMultiplier * Math.sin((double)nextTick / rotateSpeed + (double)this.getOffset()), lastVec.y() + (this.tracksGround ? 0.5 : 0.0), lastVec.z() - radiusMultiplier * Math.cos((double)nextTick / rotateSpeed + (double)this.getOffset()));
        }
        Vec3 lastVec = new Vec3(owner.getX() - radiusMultiplier * Math.sin((double)nextTick / rotateSpeed + (double)this.getOffset()), owner.getY() + 1.0 - (owner.isShiftKeyDown() ? 0.25 : 0.0), owner.getZ() - radiusMultiplier * Math.cos((double)nextTick / rotateSpeed + (double)this.getOffset()));
        this.entityData.set(LAST_POS, (Object)owner.position);
        return lastVec;
    }

    @Override
    public void buildEmitters() {
        TimelineMap timelineMap = this.resolver().spell.particleTimeline();
        OrbitTimeline projectileTimeline = (OrbitTimeline)timelineMap.get((IParticleTimelineType)ParticleTimelineRegistry.ORBIT_TIMELINE.get());
        TimelineEntryData trailConfig = projectileTimeline.trailEffect;
        TimelineEntryData resolveConfig = projectileTimeline.onResolvingEffect;
        TimelineEntryData spawnConfig = projectileTimeline.onSpawnEffect;
        TimelineEntryData flairConfig = projectileTimeline.flairEffect;
        this.tickEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityOrbitProjectile)this).getRotationVector(), trailConfig.motion(), trailConfig.particleOptions());
        this.resolveEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityOrbitProjectile)this).getRotationVector(), resolveConfig.motion(), resolveConfig.particleOptions());
        this.onSpawnEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityOrbitProjectile)this).getRotationVector(), spawnConfig);
        this.flairEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityOrbitProjectile)this).getRotationVector(), flairConfig);
        this.castSound = projectileTimeline.spawnSound.sound;
        this.resolveSound = projectileTimeline.resolveSound.sound;
    }

    @Nullable
    public Entity getOwner() {
        return this.level.getEntity(((Integer)this.entityData.get(OWNER_ID)).intValue());
    }

    @Override
    public boolean canTraversePortals() {
        return false;
    }

    @Override
    public int getExpirationTime() {
        return 1200 + 600 * this.extendTimes;
    }

    @Override
    protected void onHit(@NotNull HitResult result) {
        if (this.level.isClientSide || result.getType() == HitResult.Type.MISS) {
            return;
        }
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            if (entityHitResult.getEntity().equals((Object)this.getOwner()) && !this.tracksGround) {
                return;
            }
            if (this.resolver() != null) {
                this.resolver().getNewResolver(this.resolver().spellContext.clone().makeChildContext()).onResolveEffect(this.level, result);
                this.resolveEmitter.tick(this.level);
                this.resolveSound.playSound(this.level, result.getLocation().x, result.getLocation().y, result.getLocation().z);
            }
            this.attemptRemoval();
        } else if (this.numSensitive > 0 && result instanceof BlockHitResult) {
            BlockHitResult blockraytraceresult = (BlockHitResult)result;
            if (!this.isRemoved()) {
                if (this.resolver() != null) {
                    this.resolver().getNewResolver(this.resolver().spellContext.clone().makeChildContext()).onResolveEffect(this.level, (HitResult)blockraytraceresult);
                    this.resolveEmitter.tick(this.level);
                    this.resolveSound.playSound(this.level, blockraytraceresult.getLocation().x, blockraytraceresult.getLocation().y, blockraytraceresult.getLocation().z);
                }
                this.attemptRemoval();
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(OFFSET, (Object)0);
        pBuilder.define(ACCELERATES, (Object)0);
        pBuilder.define(AOE, (Object)Float.valueOf(0.0f));
        pBuilder.define(TOTAL, (Object)0);
        pBuilder.define(LAST_POS, (Object)Vec3.ZERO);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("left", this.ticksLeft);
        tag.putInt("offset", this.getOffset());
        tag.putFloat("aoe", this.getAoe());
        tag.putInt("accelerate", this.getAccelerates());
        tag.putInt("total", this.getTotal());
        tag.putDouble("lastX", ((Vec3)this.entityData.get(EntityOrbitProjectile.LAST_POS)).x);
        tag.putDouble("lastY", ((Vec3)this.entityData.get(EntityOrbitProjectile.LAST_POS)).y);
        tag.putDouble("lastZ", ((Vec3)this.entityData.get(EntityOrbitProjectile.LAST_POS)).z);
        tag.putBoolean("canHitOwner", this.tracksGround);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.ticksLeft = tag.getInt("left");
        this.setOffset(tag.getInt("offset"));
        this.setAoe(tag.getFloat("aoe"));
        this.setAccelerates(tag.getInt("accelerate"));
        this.setTotal(tag.getInt("total"));
        this.entityData.set(LAST_POS, (Object)new Vec3(tag.getDouble("lastX"), tag.getDouble("lastY"), tag.getDouble("lastZ")));
        this.tracksGround = tag.getBoolean("canHitOwner");
    }

    @Override
    public EntityType<?> getType() {
        return (EntityType)ModEntities.ORBIT_SPELL.get();
    }
}

